<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use app\models\RoomType;

class RoomController extends Controller
{
    /**
     * Список всех типов номеров
     */
    public function actionIndex()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => RoomType::find(),
            'pagination' => false,
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Просмотр типа номера
     */
    public function actionView($id)
    {
        $model = RoomType::findOne($id);
        
        if ($model === null) {
            throw new NotFoundHttpException('Тип номера не найден');
        }

        return $this->render('view', [
            'model' => $model,
        ]);
    }
}