<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%user}}`.
 */
class m260125_115252_create_user_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey(),
            'username' => $this->string(50)->notNull()->unique(),
            'email' => $this->string(100)->notNull()->unique(),
            'password_hash' => $this->string(255)->notNull(),
            'full_name' => $this->string(150)->notNull(),
            'passport_series' => $this->string(4)->notNull(),
            'passport_number' => $this->string(6)->notNull(),
            'address' => $this->text()->notNull(),
            'phone' => $this->string(20)->notNull(),
            'auth_key' => $this->string(32),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);

         $this->insert('{{%user}}', [
            'username' => 'hotel',
            'email' => 'admin@hotel.ru',
            'password_hash' => Yii::$app->security->generatePasswordHash('hoteladmin'),
            'full_name' => 'Администратор Отеля',
            'passport_series' => '0000',
            'passport_number' => '000000',
            'address' => 'г. Москва',
            'phone' => '+7(999)-999-99-99',
            'auth_key' => Yii::$app->security->generateRandomString(),
            'created_at' => time(),
            'updated_at' => time(),
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%user}}');
    }
}
