<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%room_type}}`.
 */
class m260125_115316_create_room_type_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%room_type}}', [
            'id' => $this->primaryKey(),
             'name' => $this->string(100)->notNull(),
            'description' => $this->text()->notNull(),
            'price_per_night' => $this->decimal(10, 2)->notNull(),
            'max_guests' => $this->integer()->notNull(),
            'bed_type' => $this->string(50)->notNull(),
            'room_size' => $this->string(20),
            'amenities' => $this->text(),
            'image_url' => $this->string(255),
        ]);
        $roomTypes = [
            [
                'name' => 'Стандарт одноместный (односпальная кровать)',
                'description' => 'Уютный одноместный номер с односпальной кроватью. Идеально подходит для деловых поездок.',
                'price_per_night' => 3500,
                'max_guests' => 1,
                'bed_type' => 'Односпальная кровать',
                'room_size' => '18 м²',
                'amenities' => 'Wi-Fi, телевизор, кондиционер, мини-бар, сейф',
                'image_url' => '/images/room1.jpg'
            ],
            [
                'name' => 'Стандарт одноместный (двуспальная кровать)',
                'description' => 'Комфортабельный номер с двуспальной кроватью для одного гостя.',
                'price_per_night' => 4000,
                'max_guests' => 1,
                'bed_type' => 'Двуспальная кровать',
                'room_size' => '20 м²',
                'amenities' => 'Wi-Fi, телевизор, кондиционер, мини-бар, сейф, рабочая зона',
                'image_url' => '/images/room2.jpg'
            ],
            [
                'name' => 'Стандарт с двумя односпальными кроватями',
                'description' => 'Номер для двух гостей с двумя отдельными односпальными кроватями.',
                'price_per_night' => 5500,
                'max_guests' => 2,
                'bed_type' => 'Две односпальные кровати',
                'room_size' => '25 м²',
                'amenities' => 'Wi-Fi, телевизор, кондиционер, мини-бар, сейф, чайник',
                'image_url' => '/images/room3.jpg'
            ],
            [
                'name' => 'Люкс одноместный',
                'description' => 'Просторный люксовый номер с панорамным видом и премиальным обслуживанием.',
                'price_per_night' => 8000,
                'max_guests' => 1,
                'bed_type' => 'Королевская кровать',
                'room_size' => '35 м²',
                'amenities' => 'Wi-Fi, Smart TV, кондиционер, мини-бар, сейф, халаты, тапочки, кофемашина',
                'image_url' => '/images/room4.jpg'
            ],
            [
                'name' => 'Люкс двуместный',
                'description' => 'Роскошный двухместный номер с гостиной зоной и улучшенным сервисом.',
                'price_per_night' => 10000,
                'max_guests' => 2,
                'bed_type' => 'Две королевские кровати',
                'room_size' => '45 м²',
                'amenities' => 'Wi-Fi, Smart TV, кондиционер, мини-бар премиум, сейф, халаты, тапочки, кофемашина, джакузи',
                'image_url' => '/images/room5.jpg'
            ],
        ];
        foreach ($roomTypes as $type) {
            $this->insert('{{%room_type}}', $type);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%room_type}}');
    }
}
