<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%room}}`.
 */
class m260125_115338_create_room_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%room}}', [
            'id' => $this->primaryKey(),
             'room_type_id' => $this->integer()->notNull(),
            'room_number' => $this->string(10)->notNull()->unique(),
            'floor' => $this->integer()->notNull(),
            'status' => $this->string(20)->defaultValue('available'), // available, occupied, maintenance
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);
        $this->addForeignKey(
            'fk-room-room_type_id',
            '{{%room}}',
            'room_type_id',
            '{{%room_type}}',
            'id',
            'CASCADE'
        );

        // Добавляем номера для каждого типа
        $rooms = [];
        $roomNumber = 100;
        
        for ($i = 1; $i <= 5; $i++) {
            for ($j = 1; $j <= 10; $j++) {
                $rooms[] = [
                    'room_type_id' => $i,
                    'room_number' => (string)($roomNumber + ($i * 10) + $j),
                    'floor' => ($i <= 2) ? 1 : (($i <= 4) ? 2 : 3),
                    'status' => 'available',
                    'created_at' => time(),
                    'updated_at' => time(),
                ];
            }
        }

        foreach ($rooms as $room) {
            $this->insert('{{%room}}', $room);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%room}}');
    }
}
