<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * Class BookingService
 * @package app\models
 * 
 * @property integer $id
 * @property integer $booking_id
 * @property string $service_name
 * @property string $service_description
 * @property float $price
 * @property integer $created_at
 */
class BookingService extends ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%booking_service}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['booking_id', 'service_name'], 'required'],
            [['booking_id'], 'integer'],
            [['service_name'], 'string', 'max' => 100],
            [['service_description'], 'string'],
            [['price'], 'number', 'min' => 0],
            [['created_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'booking_id' => 'Бронирование',
            'service_name' => 'Название услуги',
            'service_description' => 'Описание услуги',
            'price' => 'Стоимость',
            'created_at' => 'Дата создания',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if ($insert) {
                $this->created_at = time();
            }
            return true;
        }
        return false;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBooking()
    {
        return $this->hasOne(Booking::class, ['id' => 'booking_id']);
    }
}