<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * Class Review
 * @package app\models
 * 
 * @property integer $id
 * @property integer $user_id
 * @property integer $booking_id
 * @property integer $rating
 * @property string $comment
 * @property integer $created_at
 * @property integer $updated_at
 */
class Review extends ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%review}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['booking_id', 'rating', 'comment'], 'required'],
            ['rating', 'integer', 'min' => 1, 'max' => 5],
            [['comment'], 'string', 'min' => 10, 'max' => 1000],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'booking_id' => 'Бронирование',
            'rating' => 'Рейтинг',
            'comment' => 'Отзыв',
            'created_at' => 'Дата создания',
            'updated_at' => 'Дата обновления',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if ($insert) {
                $this->user_id = Yii::$app->user->id;
                $this->created_at = time();
            }
            $this->updated_at = time();
            return true;
        }
        return false;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBooking()
    {
        return $this->hasOne(Booking::class, ['id' => 'booking_id']);
    }

    /**
     * Получить звезды рейтинга
     * @return string
     */
    public function getStars()
    {
        $stars = '';
        for ($i = 1; $i <= 5; $i++) {
            if ($i <= $this->rating) {
                $stars .= '★';
            } else {
                $stars .= '☆';
            }
        }
        return $stars;
    }

    /**
     * Получить форматированную дату
     * @return string
     */
    public function getFormattedDate()
    {
        return date('d.m.Y', $this->created_at);
    }
}