<?php

/* @var $this yii\web\View */
/* @var $bookingsCount int */
/* @var $usersCount int */
/* @var $newBookingsCount int */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Панель администратора';
?>
<div class="admin-index">
    <h1 class="page-title"><?= Html::encode($this->title) ?></h1>

    <div class="admin-stats">
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon" style="background: #3498db;">📊</div>
                <div class="stat-content">
                    <h3>Всего бронирований</h3>
                    <div class="stat-value"><?= $bookingsCount ?></div>
                    <a href="<?= Url::to(['bookings']) ?>" class="stat-link">
                        Посмотреть все →
                    </a>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: #27ae60;">👥</div>
                <div class="stat-content">
                    <h3>Пользователей</h3>
                    <div class="stat-value"><?= $usersCount ?></div>
                    <a href="<?= Url::to(['users']) ?>" class="stat-link">
                        Управление →
                    </a>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: #f39c12;">🆕</div>
                <div class="stat-content">
                    <h3>Новые заявки</h3>
                    <div class="stat-value"><?= $newBookingsCount ?></div>
                    <a href="<?= Url::to(['bookings', 'status' => 'new']) ?>" class="stat-link">
                        Обработать →
                    </a>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: #e74c3c;">⏰</div>
                <div class="stat-content">
                    <h3>Требуют внимания</h3>
                    <div class="stat-value"><?= $newBookingsCount ?></div>
                    <a href="<?= Url::to(['bookings']) ?>" class="stat-link">
                        Проверить →
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="admin-quick-actions">
        <h2 class="section-title">Быстрые действия</h2>
        <div class="actions-grid">
            <a href="<?= Url::to(['bookings']) ?>" class="action-card">
                <div class="action-icon">📋</div>
                <h3>Управление бронированиями</h3>
                <p>Просмотр, редактирование и изменение статусов всех бронирований</p>
            </a>
            
            <a href="<?= Url::to(['users']) ?>" class="action-card">
                <div class="action-icon">👤</div>
                <h3>Управление пользователями</h3>
                <p>Просмотр списка пользователей и управление их данными</p>
            </a>
            
            <a href="<?= Url::to(['/room/index']) ?>" class="action-card">
                <div class="action-icon">🏨</div>
                <h3>Управление номерами</h3>
                <p>Просмотр и редактирование информации о номерах отеля</p>
            </a>
            
            <div class="action-card">
                <div class="action-icon">📊</div>
                <h3>Статистика</h3>
                <p>Просмотр статистики и отчетов по бронированиям</p>
                <small style="color: #7f8c8d;">(В разработке)</small>
            </div>
        </div>
    </div>

    <div class="recent-activity">
        <h2 class="section-title">Последние действия</h2>
        <div class="activity-list">
            <div class="activity-item">
                <div class="activity-icon">➕</div>
                <div class="activity-content">
                    <p>Новая заявка на бронирование от пользователя</p>
                    <span class="activity-time">5 минут назад</span>
                </div>
            </div>
            
            <div class="activity-item">
                <div class="activity-icon">✅</div>
                <div class="activity-content">
                    <p>Бронирование #15 подтверждено</p>
                    <span class="activity-time">2 часа назад</span>
                </div>
            </div>
            
            <div class="activity-item">
                <div class="activity-icon">👤</div>
                <div class="activity-content">
                    <p>Новый пользователь зарегистрировался</p>
                    <span class="activity-time">Вчера, 18:30</span>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.admin-index {
    animation: fadeIn 0.5s ease;
}

.admin-stats {
    margin-bottom: 3rem;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.stat-card {
    background: white;
    border-radius: 8px;
    padding: 1.5rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    display: flex;
    align-items: center;
    gap: 1.5rem;
    transition: transform 0.3s;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
    color: white;
}

.stat-content {
    flex: 1;
}

.stat-content h3 {
    color: #7f8c8d;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 2.5rem;
    font-weight: bold;
    color: #2c3e50;
    margin-bottom: 0.5rem;
}

.stat-link {
    color: #3498db;
    text-decoration: none;
    font-size: 0.9rem;
    font-weight: 500;
}

.stat-link:hover {
    text-decoration: underline;
}

.section-title {
    color: #2c3e50;
    margin-bottom: 1.5rem;
    font-size: 1.5rem;
    position: relative;
    padding-bottom: 0.5rem;
}

.section-title::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 60px;
    height: 3px;
    background: #3498db;
    border-radius: 2px;
}

.admin-quick-actions {
    margin-bottom: 3rem;
}

.actions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.action-card {
    background: white;
    border-radius: 8px;
    padding: 2rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    text-decoration: none;
    color: inherit;
    transition: all 0.3s;
    border: 2px solid transparent;
}

.action-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
    border-color: #3498db;
}

.action-icon {
    font-size: 2.5rem;
    margin-bottom: 1rem;
}

.action-card h3 {
    color: #2c3e50;
    margin-bottom: 0.75rem;
    font-size: 1.2rem;
}

.action-card p {
    color: #7f8c8d;
    line-height: 1.5;
    margin: 0;
}

.recent-activity {
    background: white;
    border-radius: 8px;
    padding: 2rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.activity-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.activity-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    padding: 1rem;
    border-radius: 4px;
    transition: background 0.3s;
}

.activity-item:hover {
    background: #f8f9fa;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.activity-content {
    flex: 1;
}

.activity-content p {
    color: #2c3e50;
    margin-bottom: 0.25rem;
}

.activity-time {
    color: #95a5a6;
    font-size: 0.85rem;
}

@media (max-width: 768px) {
    .stats-grid,
    .actions-grid {
        grid-template-columns: 1fr;
    }
}
</style>