<?php

/* @var $this yii\web\View */
/* @var $model app\models\Review */
/* @var $booking app\models\Booking */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Оставить отзыв';
?>
<div class="review-create">
    <h1 class="page-title"><?= Html::encode($this->title) ?></h1>

    <div class="review-form-container">
        <div class="booking-info">
            <h3>Информация о бронировании:</h3>
            <p><strong>Номер:</strong> <?= Html::encode($booking->roomType->name) ?></p>
            <p><strong>Даты:</strong> <?= date('d.m.Y', strtotime($booking->check_in_date)) ?> - <?= date('d.m.Y', strtotime($booking->check_out_date)) ?></p>
            <p><strong>Стоимость:</strong> <?= $booking->formattedTotalPrice ?></p>
        </div>

        <form class="review-form" method="post" action="<?= Url::to(['/booking/review', 'id' => $booking->id]) ?>">
            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
            
            <div class="form-group">
                <label class="form-label">Оценка *</label>
                <div class="rating-stars">
                    <?php for ($i = 5; $i >= 1; $i--): ?>
                        <label class="star-label">
                            <input type="radio" name="Review[rating]" value="<?= $i ?>" required 
                                   <?= $model->rating == $i ? 'checked' : '' ?>>
                            <span class="star">★</span>
                        </label>
                    <?php endfor; ?>
                </div>
                <?= Html::error($model, 'rating', ['class' => 'error-text']) ?>
            </div>
            
            <div class="form-group">
                <label for="review-comment" class="form-label">Отзыв *</label>
                <textarea id="review-comment" class="form-input" name="Review[comment]" 
                          rows="6" required><?= Html::encode($model->comment) ?></textarea>
                <div class="form-hint">Минимум 10 символов, максимум 1000</div>
                <?= Html::error($model, 'comment', ['class' => 'error-text']) ?>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Отправить отзыв</button>
                <a href="<?= Url::to(['/booking/view', 'id' => $booking->id]) ?>" class="btn btn-secondary">Отмена</a>
            </div>
        </form>
    </div>
</div>

<style>
.review-form-container {
    max-width: 600px;
    margin: 0 auto;
    background: white;
    padding: 2rem;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.booking-info {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 4px;
    margin-bottom: 2rem;
    border-left: 4px solid #3498db;
}

.booking-info h3 {
    color: #2c3e50;
    margin-bottom: 1rem;
}

.booking-info p {
    margin-bottom: 0.5rem;
    color: #555;
}

.rating-stars {
    display: flex;
    flex-direction: row-reverse;
    justify-content: flex-end;
    gap: 0.5rem;
}

.star-label {
    cursor: pointer;
    font-size: 2rem;
    color: #ddd;
    transition: color 0.3s;
}

.star-label input {
    display: none;
}

.star-label:hover,
.star-label:hover ~ .star-label,
.star-label input:checked ~ .star-label {
    color: #f39c12;
}

.star-label input:checked + .star {
    color: #f39c12;
}

@media (max-width: 768px) {
    .rating-stars {
        gap: 0.25rem;
    }
    
    .star-label {
        font-size: 1.5rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('.review-form');
    const commentInput = document.getElementById('review-comment');
    
    form.addEventListener('submit', function(e) {
        const comment = commentInput.value.trim();
        const rating = document.querySelector('input[name="Review[rating]"]:checked');
        
        if (!rating) {
            e.preventDefault();
            alert('Пожалуйста, выберите оценку');
            return;
        }
        
        if (comment.length < 10) {
            e.preventDefault();
            alert('Отзыв должен содержать минимум 10 символов');
            commentInput.focus();
            return;
        }
        
        if (comment.length > 1000) {
            e.preventDefault();
            alert('Отзыв не должен превышать 1000 символов');
            commentInput.focus();
            return;
        }
    });
});
</script>