<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\helpers\Url;

?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: #333;
            background: #f8f9fa;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .wrap {
            flex: 1;
        }
        
        .header {
            background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white;
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            font-size: 1.8rem;
            font-weight: bold;
            color: white;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .logo:hover {
            color: #3498db;
        }
        
        .main-nav {
            display: flex;
            gap: 1.5rem;
            align-items: center;
        }
        
        .nav-link {
            color: white;
            text-decoration: none;
            padding: 0.5rem 1rem;
            border-radius: 4px;
            transition: all 0.3s;
            position: relative;
        }
        
        .nav-link:hover {
            background: rgba(255,255,255,0.1);
            transform: translateY(-2px);
        }
        
        .nav-link.active {
            background: #3498db;
        }
        
        .nav-link::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 2px;
            background: #3498db;
            transition: all 0.3s;
            transform: translateX(-50%);
        }
        
        .nav-link:hover::after {
            width: 100%;
        }
        
        .logout-form {
            display: inline;
        }
        
        .logout-btn {
            background: #e74c3c;
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 4px;
            cursor: pointer;
            transition: background 0.3s;
            font-size: 1rem;
        }
        
        .logout-btn:hover {
            background: #c0392b;
        }
        
        .main-content {
            margin-top: 80px;
            padding: 2rem 0;
            animation: fadeIn 0.5s ease;
        }
        
        .alert {
            padding: 1rem;
            margin-bottom: 1rem;
            border-radius: 4px;
            animation: slideDown 0.3s ease;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .alert-warning {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        
        .alert button {
            float: right;
            background: none;
            border: none;
            font-size: 1.2rem;
            cursor: pointer;
        }
        
        .footer {
            background: #2c3e50;
            color: white;
            padding: 2rem 0;
            margin-top: auto;
        }
        
        .footer-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .footer-links {
            display: flex;
            gap: 1rem;
        }
        
        .footer-link {
            color: #bdc3c7;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .footer-link:hover {
            color: white;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes slideDown {
            from {
                transform: translateY(-20px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        /* Мобильная навигация */
        .menu-toggle {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 1.5rem;
            cursor: pointer;
        }
        
        @media (max-width: 768px) {
            .menu-toggle {
                display: block;
            }
            
            .main-nav {
                position: fixed;
                top: 60px;
                left: 0;
                right: 0;
                background: #2c3e50;
                flex-direction: column;
                padding: 1rem;
                transform: translateY(-100%);
                opacity: 0;
                transition: all 0.3s;
                box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            }
            
            .main-nav.active {
                transform: translateY(0);
                opacity: 1;
            }
            
            .nav-link {
                width: 100%;
                text-align: center;
            }
            
            .header-container {
                flex-wrap: wrap;
            }
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Мобильное меню
            const menuToggle = document.querySelector('.menu-toggle');
            const mainNav = document.querySelector('.main-nav');
            
            if (menuToggle) {
                menuToggle.addEventListener('click', function() {
                    mainNav.classList.toggle('active');
                });
            }
            
            // Закрытие алертов
            document.querySelectorAll('.alert button').forEach(function(button) {
                button.addEventListener('click', function() {
                    this.parentElement.style.display = 'none';
                });
            });
            
            // Автоматическое скрытие алертов через 5 секунд
            setTimeout(function() {
                document.querySelectorAll('.alert').forEach(function(alert) {
                    alert.style.display = 'none';
                });
            }, 5000);
        });
    </script>
</head>
<body>
<div class="wrap">
    <header class="header">
        <div class="container header-container">
            <a href="<?= Url::to(['/site/index']) ?>" class="logo">
                Отель "Как дома"
            </a>
            
            <button class="menu-toggle">☰</button>
            
            <nav class="main-nav">
                <a href="<?= Url::to(['/site/index']) ?>" class="nav-link <?= Yii::$app->controller->id == 'site' && Yii::$app->controller->action->id == 'index' ? 'active' : '' ?>">
                    Главная
                </a>
                
                <a href="<?= Url::to(['/room/index']) ?>" class="nav-link <?= Yii::$app->controller->id == 'room' ? 'active' : '' ?>">
                    Номера и цены
                </a>
                
                <?php if (Yii::$app->user->isGuest): ?>
                    <a href="<?= Url::to(['/site/register']) ?>" class="nav-link <?= Yii::$app->controller->action->id == 'register' ? 'active' : '' ?>">
                        Регистрация
                    </a>
                    <a href="<?= Url::to(['/site/login']) ?>" class="nav-link <?= Yii::$app->controller->action->id == 'login' ? 'active' : '' ?>">
                        Вход
                    </a>
                <?php else: ?>
                    <a href="<?= Url::to(['/booking/index']) ?>" class="nav-link <?= Yii::$app->controller->id == 'booking' ? 'active' : '' ?>">
                        Мои заявки
                    </a>
                    <span style="color: white; padding: 0.5rem 1rem;">
                        <?= Yii::$app->user->identity->username ?>
                    </span>
                    <?php if (Yii::$app->user->identity->username === 'hotel'): ?>
                        <a href="<?= Url::to(['/admin/index']) ?>" class="nav-link <?= Yii::$app->controller->id == 'admin' ? 'active' : '' ?>">
                            Панель администратора
                        </a>
                    <?php endif; ?>
                    <form action="<?= Url::to(['/site/logout']) ?>" method="post" class="logout-form">
                        <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                        <button type="submit" class="logout-btn">Выход</button>
                    </form>
                <?php endif; ?>
            </nav>
        </div>
    </header>

    <main class="main-content">
        <div class="container">
            <?php if (Yii::$app->session->hasFlash('success')): ?>
                <div class="alert alert-success">
                    <button type="button">&times;</button>
                    <?= Yii::$app->session->getFlash('success') ?>
                </div>
            <?php endif; ?>
            
            <?php if (Yii::$app->session->hasFlash('error')): ?>
                <div class="alert alert-error">
                    <button type="button">&times;</button>
                    <?= Yii::$app->session->getFlash('error') ?>
                </div>
            <?php endif; ?>
            
            <?php if (Yii::$app->session->hasFlash('warning')): ?>
                <div class="alert alert-warning">
                    <button type="button">&times;</button>
                    <?= Yii::$app->session->getFlash('warning') ?>
                </div>
            <?php endif; ?>
            
            <?php if (Yii::$app->session->hasFlash('info')): ?>
                <div class="alert alert-info">
                    <button type="button">&times;</button>
                    <?= Yii::$app->session->getFlash('info') ?>
                </div>
            <?php endif; ?>
            
            <?= $content ?>
        </div>
    </main>
</div>

<footer class="footer">
    <div class="container footer-content">
        <p>&copy; Отель "Как дома" <?= date('Y') ?></p>
        <div class="footer-links">
            <a href="#" class="footer-link">Политика конфиденциальности</a>
            <a href="#" class="footer-link">Условия использования</a>
        </div>
    </div>
</footer>
</body>
</html>