<?php

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Номера и цены';
?>
<div class="room-index">
    <h1 class="page-title"><?= Html::encode($this->title) ?></h1>
    
    <div class="rooms-grid">
        <?php foreach ($dataProvider->getModels() as $roomType): ?>
            <div class="room-card">
                <div class="room-image">
                    <div class="room-image-placeholder">
                        <span>🏨</span>
                    </div>
                </div>
                
                <div class="room-content">
                    <h3 class="room-title"><?= Html::encode($roomType->name) ?></h3>
                    
                    <div class="room-price">
                        <span class="price-amount"><?= $roomType->getFormattedPrice() ?></span>
                        <span class="price-period">/ ночь</span>
                    </div>
                    
                    <div class="room-features">
                        <div class="feature">
                            <span class="feature-icon">👥</span>
                            <span class="feature-text">До <?= $roomType->max_guests ?> гостей</span>
                        </div>
                        <div class="feature">
                            <span class="feature-icon">🛏️</span>
                            <span class="feature-text"><?= Html::encode($roomType->bed_type) ?></span>
                        </div>
                        <div class="feature">
                            <span class="feature-icon">📏</span>
                            <span class="feature-text"><?= Html::encode($roomType->room_size) ?></span>
                        </div>
                    </div>
                    
                    <p class="room-description"><?= Html::encode(mb_substr($roomType->description, 0, 150)) ?>...</p>
                    
                    <div class="room-amenities">
                        <h4>Удобства:</h4>
                        <ul>
                            <?php 
                            $amenities = explode(', ', $roomType->amenities);
                            $displayAmenities = array_slice($amenities, 0, 3);
                            foreach ($displayAmenities as $amenity): ?>
                                <li><?= Html::encode($amenity) ?></li>
                            <?php endforeach; ?>
                            <?php if (count($amenities) > 3): ?>
                                <li>и другие...</li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    
                    <div class="room-actions">
                        <?php if (!Yii::$app->user->isGuest): ?>
                            <a href="<?= Url::to(['/booking/create', 'room_type_id' => $roomType->id]) ?>" 
                               class="btn btn-primary">
                                Забронировать
                            </a>
                        <?php else: ?>
                            <a href="<?= Url::to(['/site/login']) ?>" class="btn btn-secondary">
                                Войдите, чтобы забронировать
                            </a>
                        <?php endif; ?>
                        <a href="<?= Url::to(['view', 'id' => $roomType->id]) ?>" class="btn btn-outline">
                            Подробнее
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<style>
.room-index {
    animation: fadeIn 0.5s ease;
}

.rooms-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
    gap: 2rem;
}

.room-card {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    transition: transform 0.3s, box-shadow 0.3s;
}

.room-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
}

.room-image {
    height: 200px;
    background: linear-gradient(135deg, #3498db, #2980b9);
    display: flex;
    align-items: center;
    justify-content: center;
}

.room-image-placeholder {
    font-size: 4rem;
}

.room-content {
    padding: 1.5rem;
}

.room-title {
    color: #2c3e50;
    margin-bottom: 1rem;
    font-size: 1.3rem;
}

.room-price {
    margin-bottom: 1.5rem;
}

.price-amount {
    font-size: 1.8rem;
    font-weight: bold;
    color: #27ae60;
}

.price-period {
    color: #7f8c8d;
    font-size: 0.9rem;
}

.room-features {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.feature {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
}

.feature-icon {
    font-size: 1.5rem;
    margin-bottom: 0.5rem;
}

.feature-text {
    font-size: 0.9rem;
    color: #555;
}

.room-description {
    color: #666;
    line-height: 1.6;
    margin-bottom: 1.5rem;
}

.room-amenities h4 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-size: 1.1rem;
}

.room-amenities ul {
    list-style: none;
    padding: 0;
    margin-bottom: 1.5rem;
}

.room-amenities li {
    padding: 0.25rem 0;
    color: #555;
    position: relative;
    padding-left: 1.5rem;
}

.room-amenities li:before {
    content: "✓";
    position: absolute;
    left: 0;
    color: #27ae60;
    font-weight: bold;
}

.room-actions {
    display: flex;
    gap: 0.5rem;
}

.btn-outline {
    background: transparent;
    color: #3498db;
    border: 1px solid #3498db;
    padding: 0.5rem 1rem;
    border-radius: 4px;
    text-decoration: none;
    transition: all 0.3s;
}

.btn-outline:hover {
    background: #3498db;
    color: white;
}

@media (max-width: 768px) {
    .rooms-grid {
        grid-template-columns: 1fr;
    }
    
    .room-features {
        grid-template-columns: repeat(2, 1fr);
    }
}
</style>