<?php

/* @var $this yii\web\View */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Отель "Как дома" - Главная';
?>
<div class="home-page">
    <div class="hero-section">
        <div class="hero-content">
            <h1 class="hero-title">Отель "Как дома"</h1>
            <p class="hero-subtitle">Добро пожаловать в наш уютный отель, где каждый гость чувствует себя как дома!</p>
            <div class="hero-buttons">
                <?php if (Yii::$app->user->isGuest): ?>
                    <a href="<?= Url::to(['/site/register']) ?>" class="btn btn-primary">
                        Зарегистрироваться
                    </a>
                    <a href="<?= Url::to(['/site/login']) ?>" class="btn btn-secondary">
                        Войти
                    </a>
                <?php else: ?>
                    <a href="<?= Url::to(['/booking/create']) ?>" class="btn btn-success">
                        Забронировать номер
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="features-section">
        <div class="container">
            <h2 class="section-title">Наши преимущества</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">📍</div>
                    <h3 class="feature-title">Удобное расположение</h3>
                    <p class="feature-description">Центр города, рядом с основными достопримечательностями</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🏨</div>
                    <h3 class="feature-title">Комфортабельные номера</h3>
                    <p class="feature-description">Просторные номера с современным дизайном</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">📶</div>
                    <h3 class="feature-title">Бесплатный Wi-Fi</h3>
                    <p class="feature-description">Высокоскоростной интернет на всей территории</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">👨‍🍳</div>
                    <h3 class="feature-title">Ресторан</h3>
                    <p class="feature-description">Европейская кухня от нашего шеф-повара</p>
                </div>
            </div>
        </div>
    </div>

    <div class="rooms-section">
        <div class="container">
            <h2 class="section-title">Типы номеров</h2>
            <div class="rooms-grid">
                <div class="room-card">
                    <h3 class="room-title">Стандарт (одноместный)</h3>
                    <p class="room-price">от 3 500 ₽/ночь</p>
                    <ul class="room-features">
                        <li>Односпальная кровать</li>
                        <li>18 м²</li>
                        <li>Wi-Fi, телевизор</li>
                    </ul>
                </div>
                <div class="room-card">
                    <h3 class="room-title">Стандарт (двухместный)</h3>
                    <p class="room-price">от 5 500 ₽/ночь</p>
                    <ul class="room-features">
                        <li>Две односпальные кровати</li>
                        <li>25 м²</li>
                        <li>Wi-Fi, телевизор, кондиционер</li>
                    </ul>
                </div>
                <div class="room-card">
                    <h3 class="room-title">Люкс (одноместный)</h3>
                    <p class="room-price">от 8 000 ₽/ночь</p>
                    <ul class="room-features">
                        <li>Королевская кровать</li>
                        <li>35 м²</li>
                        <li>Все удобства, панорамный вид</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="contact-section">
        <div class="container">
            <h2 class="section-title">Контакты</h2>
            <div class="contact-info">
                <div class="contact-item">
                    <div class="contact-icon">📞</div>
                    <div class="contact-details">
                        <h3>Телефон</h3>
                        <p>+7(495)-123-45-67</p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon">✉️</div>
                    <div class="contact-details">
                        <h3>Email</h3>
                        <p>info@kakdoma.ru</p>
                    </div>
                </div>
                <div class="contact-item">
                    <div class="contact-icon">📍</div>
                    <div class="contact-details">
                        <h3>Адрес</h3>
                        <p>г. Москва, ул. Примерная, д. 1</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.home-page {
    animation: fadeIn 0.8s ease;
}

.hero-section {
    background: linear-gradient(135deg, #2c3e50, #34495e);
    color: white;
    padding: 4rem 0;
    text-align: center;
    position: relative;
    overflow: hidden;
}

.hero-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="none"><path d="M0,0 L100,0 L100,100 Z" fill="rgba(255,255,255,0.05)"/></svg>');
    background-size: cover;
}

.hero-content {
    position: relative;
    z-index: 1;
    max-width: 800px;
    margin: 0 auto;
    padding: 0 20px;
}

.hero-title {
    font-size: 3rem;
    margin-bottom: 1rem;
    animation: slideDown 0.6s ease;
}

.hero-subtitle {
    font-size: 1.2rem;
    margin-bottom: 2rem;
    opacity: 0.9;
    animation: slideDown 0.6s ease 0.1s both;
}

.hero-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
    animation: slideDown 0.6s ease 0.2s both;
}

.btn {
    padding: 1rem 2rem;
    border-radius: 4px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s;
    display: inline-block;
    border: none;
    cursor: pointer;
    font-size: 1rem;
}

.btn-primary {
    background: linear-gradient(135deg, #3498db, #2980b9);
    color: white;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #2980b9, #1c6ea4);
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
}

.btn-secondary {
    background: transparent;
    color: white;
    border: 2px solid white;
}

.btn-secondary:hover {
    background: white;
    color: #2c3e50;
    transform: translateY(-2px);
}

.btn-success {
    background: linear-gradient(135deg, #27ae60, #219653);
    color: white;
}

.btn-success:hover {
    background: linear-gradient(135deg, #219653, #1e874b);
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
}

.section-title {
    text-align: center;
    margin-bottom: 3rem;
    color: #2c3e50;
    font-size: 2rem;
    position: relative;
}

.section-title::after {
    content: '';
    display: block;
    width: 60px;
    height: 3px;
    background: #3498db;
    margin: 0.5rem auto;
    border-radius: 2px;
}

.features-section {
    padding: 4rem 0;
    background: white;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
}

.feature-card {
    text-align: center;
    padding: 2rem;
    border-radius: 8px;
    background: #f8f9fa;
    transition: transform 0.3s, box-shadow 0.3s;
}

.feature-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.feature-icon {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.feature-title {
    color: #2c3e50;
    margin-bottom: 1rem;
    font-size: 1.3rem;
}

.feature-description {
    color: #7f8c8d;
    line-height: 1.6;
}

.rooms-section {
    padding: 4rem 0;
    background: #f8f9fa;
}

.rooms-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
}

.room-card {
    background: white;
    padding: 2rem;
    border-radius: 8px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    transition: transform 0.3s;
}

.room-card:hover {
    transform: translateY(-5px);
}

.room-title {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-size: 1.4rem;
}

.room-price {
    color: #27ae60;
    font-size: 1.2rem;
    font-weight: 600;
    margin-bottom: 1.5rem;
}

.room-features {
    list-style: none;
}

.room-features li {
    padding: 0.5rem 0;
    border-bottom: 1px solid #eee;
    color: #555;
}

.room-features li:last-child {
    border-bottom: none;
}

.contact-section {
    padding: 4rem 0;
    background: white;
}

.contact-info {
    max-width: 600px;
    margin: 0 auto;
}

.contact-item {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 8px;
    transition: background 0.3s;
}

.contact-item:hover {
    background: #e8f4fc;
}

.contact-icon {
    font-size: 2rem;
    min-width: 60px;
    text-align: center;
}

.contact-details h3 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-size: 1.2rem;
}

.contact-details p {
    color: #7f8c8d;
    font-size: 1.1rem;
}

@keyframes slideDown {
    from {
        transform: translateY(-20px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

@media (max-width: 768px) {
    .hero-title {
        font-size: 2rem;
    }
    
    .hero-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .btn {
        width: 100%;
        max-width: 300px;
        margin-bottom: 1rem;
    }
    
    .features-grid,
    .rooms-grid {
        grid-template-columns: 1fr;
    }
}
</style>